#pragma compile(Icon, "AutoIt_Main_v10_48x48_only_RGB-A.ico")
#include <GDIPlus.au3>
#include <GUIConstantsEx.au3>
#include <WindowsConstants.au3>

Example()

Func Example()
    AutoItSetOption("GUIOnEventMode", 1)

	_GDIPlus_Startup()
	Global $sTitle = "GDI+ Plasma / FPS: "
	Global $iSize = 8, $iWidth = 512, $iHeight = 256
    Global $hGUI = GUICreate($sTitle, $iWidth, $iHeight) ;create a test GUI

	;Create 32 bits-per-pixel device-independent bitmap (DIB) that use a mask
	Global $tBIV5HDR = DllStructCreate($tagBITMAPV5HEADER)
#Region GDI bitmap
	DllStructSetData($tBIV5HDR, 'bV5Size', DllStructGetSize($tBIV5HDR))
	DllStructSetData($tBIV5HDR, 'bV5Width', $iWidth)
	DllStructSetData($tBIV5HDR, 'bV5Height', $iHeight)
	DllStructSetData($tBIV5HDR, 'bV5Planes', 1)
	DllStructSetData($tBIV5HDR, 'bV5BitCount', 32)
	DllStructSetData($tBIV5HDR, 'biCompression', $BI_BITFIELDS)
	DllStructSetData($tBIV5HDR, 'bV5SizeImage', 0)
	DllStructSetData($tBIV5HDR, 'bV5XPelsPerMeter', 0)
	DllStructSetData($tBIV5HDR, 'bV5YPelsPerMeter', 0)
	DllStructSetData($tBIV5HDR, 'bV5ClrUsed', 0)
	DllStructSetData($tBIV5HDR, 'bV5ClrImportant', 0)
	DllStructSetData($tBIV5HDR, 'bV5RedMask', 0x00FF0000)
	DllStructSetData($tBIV5HDR, 'bV5GreenMask', 0x0000FF00)
	DllStructSetData($tBIV5HDR, 'bV5BlueMask', 0x000000FF)
	DllStructSetData($tBIV5HDR, 'bV5AlphaMask', 0xFF000000)
	DllStructSetData($tBIV5HDR, 'bV5CSType', 0)
	DllStructSetData($tBIV5HDR, 'bV5Endpoints', 0, 1)
	DllStructSetData($tBIV5HDR, 'bV5Endpoints', 0, 2)
	DllStructSetData($tBIV5HDR, 'bV5Endpoints', 0, 3)
	DllStructSetData($tBIV5HDR, 'bV5GammaRed', 0)
	DllStructSetData($tBIV5HDR, 'bV5GammaGreen', 0)
	DllStructSetData($tBIV5HDR, 'bV5GammaBlue', 0)
	DllStructSetData($tBIV5HDR, 'bV5Intent', 0)
	DllStructSetData($tBIV5HDR, 'bV5ProfileData', 0)
	DllStructSetData($tBIV5HDR, 'bV5ProfileSize', 0)
	DllStructSetData($tBIV5HDR, 'bV5Reserved', 0)
#EndRegion
	Global $pBits

    ;create buffered graphics frame set for smoother gfx object movements
;~ 	Global Const $hHBitmap = _WinAPI_CreateDIB($iWidth, $iHeight)
	Global Const $hHBitmap = _WinAPI_CreateDIBSection(0, $tBIV5HDR, $DIB_RGB_COLORS, $pBits)
	Global $tBits = DllStructCreate('dword pixel[' & 4 * $iWidth * $iHeight & ']', $pBits)

	Global Const $hDC = _WinAPI_GetDC($hGUI)
	Global Const $hDC_backbuffer = _WinAPI_CreateCompatibleDC($hDC)
	Global Const $DC_obj = _WinAPI_SelectObject($hDC_backbuffer, $hHBitmap)
	Global Const $hGfxCtxt = _GDIPlus_GraphicsCreateFromHDC($hDC_backbuffer)
;~ 	_GDIPlus_GraphicsSetCompositingQuality($hGfxCtxt, 2)
	Global Const $hBrush = _GDIPlus_BrushCreateSolid()

	GUISetState()

    GUISetOnEvent($GUI_EVENT_CLOSE, "_Exit")

	Local $m = 0, $n = 0, $iRowOffset, $iX, $iY, $iR, $iG, $iB, $t
	Local $iNewWidth = $iWidth / $iSize, $iNewHeight = $iHeight / $iSize

	Global $iFPS = 0
	AdlibRegister("FPS", 1000)

    Do
		For $iY = 0 To $iNewHeight - 1
			For $iX = 0 To $iNewWidth - 1
				$iR = Abs(Floor((Cos(($iX + $n + $iY + Sin($iX * 2)) / 20) * 128) + (Sin(($iX - $m + $iY) / 32) * 128)))
				$iR = $iR > 255 ? 255 : $iR
				$iG = Abs(Floor(Sin(($iX + $m - $iY + Cos($iY * 4)) / 24) * 24 - Cos(($iX - $n + $iY) / 128) * 256))
				$iG = $iG > 255 ? 255 : $iG
				$iB = Abs(Floor((Cos(($iX - Sin($iY / ($iX + $m)) - Cos($iY * 4)) / 256) * 128) + (Sin((-$iX + $n + $iY) / 512) * 128)))
				$iB = $iB > 255 ? 255 : $iB
				DllCall($__g_hGDIPDll, "int", "GdipSetSolidFillColor", "handle", $hBrush, "dword", 0x7F000000 + $iR * 0x10000 + $iG * 0x100 + $iB) ;faster than BitShift!
;~ 				DllCall($__g_hGDIPDll, "int", "GdipSetSolidFillColor", "handle", $hBrush, "dword", 0x7F000000 + BitShift($iR, -0x10) + BitShift($iG, -0x8) + $iB)
				DllCall($__g_hGDIPDll, "int", "GdipFillRectangle", "handle", $hGfxCtxt, "handle", $hBrush, "float", $iX, "float", $iY, "float", $iSize, "float", $iSize)
;~ 				DrawRectManually($tBits, $iX, $iY, $iSize, $iSize, $iWidth, 0x7F000000 + BitShift($iR, -0x10) + BitShift($iG, -0x8) + $iB)
			Next
		Next
		$m += .25
		$n += 1.25 * Sin($m / 10) * 5

;~ 		_WinAPI_BitBlt($hDC, 0, 0, $iWidth, $iHeight, $hDC_backbuffer, 0, 0, $SRCCOPY)
		_WinAPI_StretchBlt($hDC, 0, 0, $iWidth, $iHeight, $hDC_backbuffer, 0, 0, $iNewWidth, $iNewHeight, $SRCCOPY)
		$iFPS += 1
    Until False
EndFunc   ;==>Example

Func DrawRectManually(ByRef $tBitmapData, $iPosX, $iPosY, $iW, $iH, $iWidth, $iARGB = 0xFF000000)
	Local $iX, $iY
	For $iY = $iH - 1 to 0 Step - 1
		For $iX = $iW To 1 Step - 1
			$tBitmapData.Pixel(($iPosX + $iX  + ($iY + $iPosY) * $iWidth)) = $iARGB
		Next
	Next
EndFunc

Func FPS()
	WinSetTitle($hGUI, "", $sTitle & $iFPS)
	$iFPS = 0
EndFunc

Func _Exit()
    ;cleanup GDI+ resources
    _GDIPlus_GraphicsDispose($hGfxCtxt)
	_GDIPlus_BrushDispose($hBrush)
	_WinAPI_SelectObject($hDC, $DC_obj)
	_WinAPI_DeleteObject($hHBitmap)
	_WinAPI_ReleaseDC($hGUI, $hDC)
    _GDIPlus_Shutdown()
    GUIDelete($hGUI)
    Exit
EndFunc   ;==>_Exit